<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Recovery;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\User\UserRecoveryTable;

final class UserRecoveryBuilder implements InterfaceUserRecoverySetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitUserRecoverySetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            UserRecoveryTable::USER_ID => '',

            UserRecoveryTable::META_ACCESS_OTP    => '',
            UserRecoveryTable::META_ACCESS_TOKEN  => '',
            UserRecoveryTable::META_TIMES_FAILED  => '0',
            UserRecoveryTable::META_IS_EXPIRED    => UserRecoveryEnum::META_IS_EXPIRED_NO,

            UserRecoveryTable::STAMP_REGISTRATION => System::isoDateTime(),
            UserRecoveryTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): UserRecoveryModel
    {
        return UserRecoveryModel::createFromData(
            array(
                // user id

                UserRecoveryTable::USER_ID => $this -> userId

                ?? $this -> defaultValues[UserRecoveryTable::USER_ID],

                // meta access otp

                UserRecoveryTable::META_ACCESS_OTP => $this -> metaAccessOTP

                ?? $this -> defaultValues[UserRecoveryTable::META_ACCESS_OTP],

                // meta access token

                UserRecoveryTable::META_ACCESS_TOKEN => $this -> metaAccessToken

                ?? $this -> defaultValues[UserRecoveryTable::META_ACCESS_TOKEN],

                // meta times failed

                UserRecoveryTable::META_TIMES_FAILED => $this -> metaTimesFailed

                ?? $this -> defaultValues[UserRecoveryTable::META_TIMES_FAILED],

                // meta is expired

                UserRecoveryTable::META_IS_EXPIRED => $this -> metaIsExpired

                ?? $this -> defaultValues[UserRecoveryTable::META_IS_EXPIRED],

                // stamp registration

                UserRecoveryTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[UserRecoveryTable::STAMP_REGISTRATION],

                // stamp last update

                UserRecoveryTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[UserRecoveryTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
